#![allow(clippy::result_large_err)]

use std::collections::HashMap;

use serde::{Deserialize, Serialize};

use crate::{
    action::{ActionError, Context},
    action_impl::ActionImpl,
};

/// Set environment variables for later actions.
#[derive(Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
pub struct Setenv {
    set: HashMap<String, String>,
}

impl ActionImpl for Setenv {
    fn execute(&self, context: &mut Context) -> Result<(), ActionError> {
        for (k, v) in self.set.iter() {
            context.set_env(k, v);
        }
        Ok(())
    }
}
