#!/usr/bin/env bash
#
# This is invoked by the Ambient test suite. It's not meant to be
# used directly.

set -xeuo pipefail

AMBIENT_IMAGE="$1"
TARGET="$2"
shift 2

export TMP="$(mktemp -d)"
trap 'rm -rf "$TMP"' EXIT

cargo install --debug --bins --path=. --root="$TMP" --target "$TARGET"
rm -f test.log
python3 test.py --log test.log --env "BINDIR=$TMP/bin" --env "IMAGE=$AMBIENT_IMAGE" "$@"
