# Release notes for `sopass`

`sopass` is a command line manager that use any implementation of the
Stateless OpenPGP interface for cryptography. This file documents
important user-visible changes.

## Version 0.5.0, released 2025-05-03

* Breaking change: it is no longer possible to add a value from the
  command line. In other words, `sopass value add foo bar` no longer
  works. This is because this syntax makes it too easy for the value
  to leak while the command runs, or via shell history files. It's still
  possible to tell `sopass` to read the value from a named file, or
  from its standard input.

* It is now possible to remove a certificate from the store.

* The store can be exported to a clear text file, and such a file can
  be imported into another store. This allows easier migrations in the
  future, in case the store format changes.

* The SOP program name and arguments are now logged at the `debug`
  level to make it easier to figure out what's wrong.

* The error message when the SOP implementation fails now correctly
  shows the exit code and standard error output. Previously it showed
  the SOP program name and exit code, respectively. That was deemed to
  be less than ideal.

## Version 0.4.0, released 2025-03-22

* `sopass` now supports using OpenPGP cards for decryption. This is
  not currently supported by the SOP specification itself, but the
  [`rsop-oct` program](https://crates.io/crates/rsop-oct) supports the
  SOP`decrypt` operation. The difference from SOP is that `rsoct
  decrypt` takes a certificate to identify the private key, instead of
  the private key directly. With OpenPGP cards, the private key is not
  directly accessible.

  To use an OpenPGP card, import the key to your OpenPGP card (I used
  `oct` from
  [`openpgp-card-tools`](https://crates.io/crates/openpgp-card-tools)).
  Add the card user PIN to `~/.config/openpgp-card-state/config.toml`.
  Add the certificate for they key on the card with `sopass cert add`.
  Add `sop_decrypt: rsoct` to your `sopass` configuration file. Verify
  that things work with `sopass value list`.

* `sopass` will now reject a configuration file that has unknown
  fields. This means it won't run. This is technically a breaking
  change, for someone whose configuration file isn't valid.

* The source tree now has a rudimentary shell script
  (`pass-to-sopass.sh`) to convert a `pass` password store into
  `sopass`. It's not particularly well tested, but an earlier version
  of it worked for me.

## Version 0.3.0, released 2025-03-02

* `sopass` now reads the `~/.config/sopass/sopass.yml` configuration
  file (location is sensitive to XDG directory settings) by default, or one
  specified by the `--config` option.

* When adding a value (`sopass value add`), `sopass` can now read it
  from a named file (`--file` option), or the standard input
  (`--stdin`). The old way of giving the value on the command line
  also works, though this may be removed in the future, for security.
  
* The default SOP implementation is now `rsop`, since that is now
  included in Debian.

* There is now built-in help for all command line arguments, including
  sub-commands and option, as well as a rudimentary manual page.


## Version 0.2.0, released 2025-01-20

* The password store can now store any number of certificates, and the
  store gets encrypted with all of them when it's modified. This is
  allows the store to be synchronized between hosts, with each host
  having its own key.

* The default SOP implementation has been changed from `rsop` to
  `sqop` as its easier for Lars to install it his CI environment.

* There is now rudimentary `deb` packaging. This is not ready for
  upload to Debian, but suffices for personal use by Lars.

## Version 0.1.0, released 2025-01-01

This was the first release.
