#!/bin/bash
#
# Convert a password-store repository to a sopass one.

set -euo pipefail

find ~/.password-store/ -type f -printf '%P\n' |
	grep -Fv -e .gpg-id -e .git |
	sed 's/\.gpg$//' |
	while read x; do
		echo "$x"
		value="$(pass show "$x")"
		sopass value add "$x" -- "$value"
	done
