//! The `version` sub-command.

use clap::Parser;

use crate::{Config, LeafCommand};

/// The `version` sub-command.
#[derive(Debug, Parser)]
pub struct VersionCommand {}

impl LeafCommand for VersionCommand {
    type Error = VersionError;

    fn run(&self, _config: &Config) -> Result<(), VersionError> {
        println!("{} {}", env!("CARGO_PKG_NAME"), env!("CARGO_PKG_VERSION"));
        Ok(())
    }
}

/// Possible errors from [`VersionCommand`] (this can't fail).
#[derive(Debug, thiserror::Error)]
pub enum VersionError {}
