//! Library part of the `sopass` crate.
//!
//! While `sopass` is meant to be command line program, the core parts
//! are implemented as a library that can be used in other programs.

#![deny(missing_docs)]

pub mod cmd;
pub mod config;
pub mod sop;
pub mod store;

pub use config::Config;

/// Trait for lowest level sub-commands.
pub trait LeafCommand {
    /// Type of error from running the sub-command.
    type Error;

    /// Run the sub-command.
    fn run(&self, config: &Config) -> Result<(), Self::Error>;
}

const DEFAULT_VALUES_FILENAME: &str = "values.sopass";
const DEFAULT_CERT_FILENAME: &str = "default.cert";
const DEFAULT_KEY_FILENAME: &str = "default.key";
