//! Implement the `config` sub-command.

use clap::Parser;

use crate::{Config, LeafCommand};

/// The `config` sub-command.
#[derive(Debug, Parser)]
pub struct ConfigCommand {}

impl LeafCommand for ConfigCommand {
    type Error = ConfigError;

    fn run(&self, config: &Config) -> Result<(), ConfigError> {
        print!("{}", config.pretty_json()?);
        Ok(())
    }
}

/// Errors returned from the `config` sub-command.
#[derive(Debug, thiserror::Error)]
pub enum ConfigError {
    /// An error from the [`crate::config`] module.
    #[error(transparent)]
    Config(#[from] crate::config::ConfigError),
}
