//! The `key` sub-command.

use clap::Parser;

use crate::{sop::SopError, Config, LeafCommand};

/// Extract certificate from the key file on this device.
#[derive(Debug, Parser)]
pub struct ExtractCert {}

impl LeafCommand for ExtractCert {
    type Error = KeyError;

    fn run(&self, config: &Config) -> Result<(), KeyError> {
        let sop = config.sop();
        let cert = sop.extract_cert()?;
        let cert = String::from_utf8_lossy(cert.as_bytes());
        println!("{cert}");
        Ok(())
    }
}

/// Errors from the `key` sub-command.
#[derive(Debug, thiserror::Error)]
pub enum KeyError {
    /// Error from running SOP.
    #[error(transparent)]
    Sop(#[from] SopError),
}
