# `sopass` --- command line password manager using SOP

`sopass` manages passwords on the command line using the [stateless
OpenPGP interface
(SOP)](https://datatracker.ietf.org/doc/draft-dkg-openpgp-stateless-cli/)
for encryption. It is a re-interpretation of the concept championed by
`pass`, but using SOP. It does not try to be compatible with `pass`,
only to fit in the same ecological niche.

[`pass`](https://www.passwordstore.org/), also known as
"passwordstore" and described as "the standard unix password manager"
is a command line password manager that uses GnuPG for encryption.
`sopass` prefers SOP to avoid a lock-in to a specific implementation.

## Hacking

This program is implemented with the Rust language. The usual Rust
conventions apply: see `Cargo.toml` for metadata and dependencies, and
`src` for the source code.

The acceptance test suite is implemented using
[Subplot](https://subplot.tech/), and the way we use it uses Python
for scenario step implementations. To run the test suite, run `make check`
or run just `make` to also format the Subplot document (`sopass.md`)
as HTML.
