# vmadm README

vmadm is a tool to create and destroy virtual machines running
under a local libvirt. Virtual machines are described in specification
files, using YAML:

~~~yaml
foo:
  cpus: 4
  memory_mib: 4096
  image_size_gib: 100

bar:
  cpus: 1
  memory_mib: 512
  image_size_gib: 1
~~~

All the machines in a specification file are created or destroyed at
once.

## Usage

Given a specification file `machines.yaml`, to create virtual machines
run:

~~~sh
$ vmadm new machines.yaml
~~~

To delete them:

~~~sh
$ vmadm delete machines.yaml
~~~

Creating a VM creates a disk image of qcow2 format, based on a base
image, also of qcow2 format. Deleting the VM deletes the image file as
well. Image files are named after the VM and put into the configured
image directory, unless the specification file names an image file
explicitly.

To get built-in command line help:

~~~sh
$ vmadm help
$ vmadm --help
~~~

A base image is an image with some operating system already installed.
It should use [cloud-init][] on first boot to configure hostname and
SSH keys, or at least not mind that there is an extra ISO disk with
cloud-init configuration attached to the VM. It should open an SSH
port when it has booted. Other than that, vmadm doesn't care what it
is. For Debian, the pre-made OpenStack cloud-image at
<https://cloud.debian.org/> works well. You need to download the base
image yourself, vmadm doesn't do that for you.

## Configuration

The default configuration file is `vmadm/config.yaml` under the XDG
configuration directory; by default, this is
`~/.config/vmadm/config.yaml`. The configuration file may specify the
following fields:

* `default_base_image` &ndash; path to the base image to use by default
* `default_image_gib` &ndash; default size of new image for a VM, in GiB
* `default_memory_mib` &ndash; default amount of memory for a VM, in MiB
* `default_cpus` &ndash; default number of CPUs for a VM
* `default_generate_host_certificate` &ndash; should SSH host
  certificates be generated by default?
* `default_networks` &ndash; networks to which VM should be added
* `image_directory` &ndash; directory where VM image files are put
* `authorized_keys` &ndash; list of filenames to SSH public keys, to
  be put into the default user's `authorized_keys` file in the VM
* `ca_key` &ndash; path name to default CA *private* key


## Specification fields

The specification file is YAML and may specify the following fields,
all of which override some default from the configuration.

* `ssh_key_files` &ndash; overrides `authorized_keys`
* `image_size_gib` &ndash; overrides `default_image_giv`
* `memory_mib` &ndash; overrides `default_memory_mib`
* `cpus` &ndash; overrides `default_cpus`
* `base` &ndash; overrides `default_base_image`
* `image` &ndash; overrides default image file name; must include
* `image` &ndash; overrides default image file name; must include
  path name, is not put into the image directory by default
* `generate_host_certificate` &ndash; override host certification
  setting
* `networks` &ndash; networks to which VM should be added; if this
  field and the `default_networks` field in the config are not
  specified, add to the `default` network
* `ca_key` &ndash; overrides default CA key
* `rsa_host_key` &ndash; RSA host key to install on host
* `rsa_host_cert` &ndash; RSA host certificate to install on host
* `dsa_host_key` &ndash; DSA host key to install on host
* `dsa_host_cert` &ndash; DSA host certificate to install on host
* `ecdsa_host_key` &ndash; ECDSA host key to install on host
* `ecdsa_host_cert` &ndash; ECDSA host certificate to install on host
* `ed25519_host_key` &ndash; Ed25519 host key to install on host
* `ed25519_host_cert` &ndash; Ed25519 host certificate to install on host

The various `host_key` and `host_cert` fields specify *private* host
keys and certificates to be installed in the new VM. The public key is
computed from the private key, so there's no need to specify it
explicitly. The fields should contain the text of the key or
certificate, not its filename.

If *any* host key is specified, no host certificate is generated: the
`generate_host_certificate` setting is ignored. If no host keys is
specified, an Ed25519 key is generated and signed with the specified
CA certificate. The generated key and certificate are installed in the
new VM.

In other words, if you specify any host keys, you get to do everything
by hand. If you want to keep things easy, don't specify any host keys
and let vmadm generate a host key and host certificate for a VM.

## Logging

To turn on logging, set the environment variable `VMADM_LOG`:

~~~sh
$ VMADM_LOG=vmadm::libvirt vmadm list
 DEBUG vmadm::libvirt > connecting to libvirtd qemu:///system
 DEBUG vmadm::libvirt > listing all domains
$ 
~~~

vmadm uses the `env_logger` Rust library for logging, which is
documented at <https://docs.rs/env_logger>. The environment variable
can enable by log level, or by code module, or both. Setting it to
`trace` gives the most detailed logging.

# Using host certificates

Host certificates allow you to access a newly created VM without
having to accept its host key. This is especially useful the VM gets
recreated and the host key changes. You need to configure your SSH
client to trust certificates made with a given SSH CA key, but that is
a one-time operation.

You need to create an SSH key used as a CA key for host certification.
Run this command:

~~~sh
$ mkdir -m 0700 ~/.ssh/ca
$ ssh-keygen -f ~/.ssh/ca/vmadm_ca -t ed25519 -N ''
~~~

This creates a key **without a passphrase**, because vmadm does not
currently support CA keys with passphrases.

Keep the CA key secure. Don't use it for anything else.

Add the following to the `known_hosts` file your SSH client uses, all
on one one:

~~~
@cert-authority * XXXX
~~~

where `XXX` is the public key part of the CA key, as stored in
`~/.ssh/ca/vmadm_ca.pub` in the example above. This tells your client
that the CA key on the line should be accepted for all hosts (`*`).
You can restrict it to only some hosts if you prefer.

# Setup of host

The host where vmadm is run needs to have libvirt running and you must
have access to the `qemu:///system` connection.
The Debian wiki has some useful documentation: 

* <https://wiki.debian.org/libvirt>
* <https://wiki.debian.org/KVM>

I set up my own libvirt hosts using an Ansible role:
<http://git.liw.fi/ansibleness/tree/ansible/roles/vmhost>. It works on
Debian. The short version:

* install
  - `libvirt` (Debian packages `libvirt-daemon-system`,
    `libvirt-daemon`, `libvirt-daemon`)
  - `virt-install` (Debian package `virtinst`)
  - `qemu-img` (Debian package `qemu-uttils`)
  - NSS lookups for VMs (Debian package `libnss-libvirt`)
  - SSH client (Debian package `openssh-client`)
* make sure you are in the `libvirt` group
* edit `/etc/nsswitch.conf` to have `libvirt libvirt_guest` in the
  `hosts` line

# Legalese

Copyright © 2021-2021  Lars Wirzenius

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

A copy of the full license is in the file [COPYING](COPYING).
